$(function() {
	var userId = 5;
	var userIdMap = {"userId":userId};
	
	var urlvars = getUrlVars();
	var activityId = parseInt(urlvars['id'], 10);
	var activityIdMap = {"activityId":activityId};
	
	$('#div-two').on('click','button#back',function(e){
		document.location='./data-sources.html?id='+activityId;
	});
	$('#div-two').on('click','button#next',function(e){
		document.location='./project-submit.html?id='+activityId;
	});
	
	
	// populate the user request info
	$.ajax({
		url:'../dart/getActivityInfo.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(activityIdMap),
		success:function(data,textStatus,three) {
			if(textStatus==="success" ) {
				var projectName = Mustache.render($(".projectNameTemplate").html(),data);
				$('div#div-zero').html(projectName);
			}
		}
	});
	
	// populate the document info
	$.ajax({
		url:'../dart/listDocumentsByActivity.json',
		type:'POST',
		contentType:'application/json',
		dataType:'json',
		data:JSON.stringify(activityIdMap),
		success:function(data,textStatus,three) {
			if(textStatus==="success" ) {
				var tableBody = Mustache.render($(".documentRowTemplate").html(),data);
				$('div#div-one table tbody').html(tableBody);
				
				// TODO- populate rows with electronic documents
				// TODO- populate rows that have yet to be uploaded
			}
		}
	});
});

//Read a page's GET URL variables and return them as an associative array.
getUrlVars = function()
{
var vars = [], hash;
var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
for(var i = 0; i < hashes.length; i++)
{
    hash = hashes[i].split('=');
    vars.push(hash[0]);
    vars[hash[0]] = hash[1];
}
return vars;
}